/*:
 * @plugindesc キーボードのCキーでコモンイベントを実行する（変数302のIDを使用）
 * @author hisamon
 *
 * @param EnableSwitchID
 * @type number
 * @desc このスイッチIDがONのときのみCキーが有効になります
 * @default 12
 */

(function() {
  const params = PluginManager.parameters("SelectableKeyCommonEvents_CKeySupport");
  const enableSwitch = Number(params["EnableSwitchID"] || 11);

  const C_KEY_CODE = 67;
  const CUSTOM_C_KEY = "custom_c_key";
  let cKeyBuffered = false; // バッファ用フラグ

  const _Scene_Map_update = Scene_Map.prototype.update;
  Scene_Map.prototype.update = function() {
    _Scene_Map_update.call(this);

    if (!Input.keyMapper[C_KEY_CODE]) {
      Input.keyMapper[C_KEY_CODE] = CUSTOM_C_KEY;
    }

    if (!$gameSwitches.value(enableSwitch)) return;
    if ($gameTemp.isCommonEventReserved()) return;
    if ($gameMap.isEventRunning()) return;
    if ($gameMessage.isBusy()) return;

    // 移動中にCキーが押されたらバッファする
    if ($gamePlayer.isMoving()) {
      if (Input.isTriggered(CUSTOM_C_KEY)) {
        cKeyBuffered = true;
      }
      return;
    }

    // 停止中にCキーが押されたらすぐ発動
    if (Input.isTriggered(CUSTOM_C_KEY)) {
      this.callCommonEvent();
      return;
    }

    // 移動直後にバッファが残っていたら発動
    if (cKeyBuffered) {
      cKeyBuffered = false;
      this.callCommonEvent();
    }
  };

  // 共通イベント呼び出し処理を関数化
  Scene_Map.prototype.callCommonEvent = function() {
    const commonId = $gameVariables.value(302);
    if (commonId > 0) {
      $gameTemp.reserveCommonEvent(commonId);
    }
  };
})();